
# contourLines.py
# https://matplotlib.org/stable/plot_types/arrays/contour.html#sphx-glr-plot-types-arrays-contour-py
'''
  Labelled contour lines representing a 3D equation. The labels explain
  the z values along particular contours.
'''

import matplotlib.pyplot as plt
import numpy as np


x = np.arange(-3.0, 3.0, 0.025) 
y = np.arange(-2.0, 2.0, 0.025)
X, Y = np.meshgrid(x, y)   # numpy output required

# build curve for generating z-coords
Z1 = np.exp(-X**2 - Y**2)  # 2D Gaussian
Z2 = np.exp(-(X-1)**2 - (Y -1)**2)
Z = (Z1 - Z2) * 2  # difference of Gaussians

cts = plt.contour(X, Y, Z)   # , colors="k")
plt.clabel(cts, inline=True, fontsize=10)
plt.title('Labeled Contour Lines')
plt.xlabel('x')
plt.ylabel('y')
plt.show()