
# colorMap.py
# https://matplotlib.org/stable/plot_types/arrays/imshow.html#sphx-glr-plot-types-arrays-imshow-py
# https://matplotlib.org/stable/gallery/color/colorbar_basics.html
'''
  A blue color map relating students, subjs, and their scores.
  Includes a color bar to explain the color-to-score mapping.
'''


import matplotlib.pyplot as plt

nms = ['Sam','Jim','John','Sue','Mike','Jane'] 
subjs = ['Maths','Physics','English','Chemistry',
         'History','Comp Sci']
marks = [[50, 74, 40, 59,90, 98],
         [72, 85, 64, 33, 47, 87],
         [52, 97, 44, 73, 17, 56],
         [69, 45, 89, 79,70, 48],
         [87, 65, 56, 86, 72, 68],
         [90, 29, 78, 66, 50, 32]]
 
# display the categories as x- and y- axis labels
plt.xticks(ticks=range(len(nms)), labels=nms, rotation=90)
plt.yticks(ticks=range(len(subjs)),labels=subjs)

hm=plt.imshow(marks,cmap='Blues_r',interpolation="nearest")
plt.colorbar(hm)   
plt.title("Students and their Subject Marks")
plt.show()