
# circleSliders.py
# https://matplotlib.org/stable/gallery/widgets/
'''
Three sliders and a button for controlling a circle.
 # radius slider changes the circle's radius
 # the x- and y- sliders adjust the (x,y) center.

'''

import math
from frange import *

import matplotlib.pyplot as plt
from matplotlib.widgets import Slider, Button


def update(val):
  sr = radiusSlider.val
  sx = xSlider.val
  sy = ySlider.val
  line.set_xdata( [ sr*math.sin(t)+sx for t in ts] )
  line.set_ydata( [ sr*math.cos(t)+sy for t in ts] )
  fig.canvas.draw_idle()


def reset(event):
  radiusSlider.reset()
  xSlider.reset()
  ySlider.reset()


# ------------------------

fig, ax = plt.subplots(figsize=(6,6))
plt.subplots_adjust(left=0.25, bottom=0.25)
plt.axis('equal')
plt.xlim(-16,16)
plt.ylim(-16,16)
plt.grid()

# initial value for the circle
rad0 = 2
x0 = 0
y0 = 0

ts = linspace(0, 2*math.pi, 100)
xs = [ x0 + rad0 * math.sin(t) for t in ts]
ys = [ y0 + rad0 * math.cos(t) for t in ts]
line, = plt.plot(xs, ys, lw=2)


# three sliders
radiusAxis = plt.axes([0.25, 0.15, 0.65, 0.03])
radiusSlider = Slider(radiusAxis, 'radius', 1, 5, valinit=rad0)
radiusSlider.on_changed(update)

xAxis = plt.axes([0.25, 0.10, 0.65, 0.03])
xSlider = Slider(xAxis, 'x center', -10, 10, valinit=x0)
xSlider.on_changed(update)

yAxis = plt.axes([0.25, 0.05, 0.65, 0.03])
ySlider = Slider(yAxis, 'y center', -10, 10, valinit=y0)
ySlider.on_changed(update)

# the button
resetAxis = plt.axes([0.8, 0.0, 0.1, 0.04])
button = Button(resetAxis, 'Reset')
button.on_clicked(reset)

plt.show()
