
# butterfly.py
# info: https://en.wikipedia.org/wiki/Butterfly_curve_(transcendental)
# https://matplotlib.org/stable/gallery/pie_and_polar_charts/polar_demo.html
'''
  A butterfly curve generated using polar coordinates.
  See spiral.py for how to customize a polar plot.
'''

import math
import matplotlib.pyplot as plt
from frange import *

n = 5 # no. of loops
# generate radii from angles
thetas = linspace(0, 2*math.pi*n, 100*n)
rs = [ math.exp(math.sin(theta)) - 2*math.cos(4*theta) + 
       math.sin(theta/12)**5 
                     for theta in thetas]
plt.polar(thetas, rs)
plt.title("Butterfly Curve")
plt.show()