
# boxplots.py
# https://matplotlib.org/stable/plot_types/stats/boxplot_plot.html#sphx-glr-plot-types-stats-boxplot-plot-py
'''
  Four box plots of random data generated with Gaussian distributions
  with specific means and stdevs.
'''

import matplotlib.pyplot as plt
import math, random

data1 = [ random.gauss(100, 10) for _ in range(200)]
data2 = [ random.gauss(90, 20) for _ in range(200)]
data3 = [ random.gauss(80, 30) for _ in range(200)]
data4 = [ random.gauss(70, 40) for _ in range(200)]
ds = [data1, data2, data3, data4]

plt.boxplot(ds, showmeans=True)  # include means
plt.xticks([1, 2, 3, 4], ["Jim", "John", "Joan", "Jane"])
                          # change the x-axis labels
plt.show()

