
# animLine3d.py
# https://matplotlib.org/stable/gallery/animation/index.html
'''
  An animated 3D spiral line which repeats.
'''


from matplotlib import pyplot as plt
from matplotlib import animation
import math
from frange import *



def update(i):
    line.set_data(xs[:i], ys[:i])
    line.set_3d_properties(thetas[:i])


N = 100

fig = plt.figure()
ax = fig.add_subplot(projection='3d')

thetas = linspace(0, 4*math.pi, N)
xs = [ math.cos(t) for t in thetas]
ys = [ math.sin(t) for t in thetas]

line, = ax.plot(xs[0:1], ys[0:1], thetas[0:1])

plt.title('Animated line 3D Plot')

plt.xlim([-1.0, 1.0])
plt.xlabel('X')

plt.ylim([-1.0, 1.0])
plt.ylabel('Y')

ax.set_zlim3d([0.0, math.ceil(4*math.pi)])
ax.set_zlabel('Z')    # no plt.zlabel()

anim = animation.FuncAnimation(fig, update, N, interval=50)

plt.show()

