
# tripleSum.py
# inputs: 100 or 200 or 300
'''
Introduction to Programming in Python
Robert Sedgewick, Kevin Wayne, Robert Dondero
Addison-Wesley, 2015
Ex 4.1.27 Three-sum analysis
https://introcs.cs.princeton.edu/python/41analysis/

Calculate the probability that no triple among n random 32-bit integers 
sums to 0, and give an approximate estimate for n equal to 1000, 2000, and 4000. 

Extra credit: Give an approximate formula for the expected number of such 
triples (as a function of n), and run experiments to validate your estimate.
'''

import random


def countZeroTriples(vals):
  n = len(vals)
  count = 0
  for i in range(n):
    for j in range(i+1, n):
      for k in range(j+1, n):
        if (vals[i] + vals[j] + vals[k]) == 0:
          count += 1
  return count


n = int(input("n=? "))

vals = [0]*n
for i in range(n):
  vals.append( random.getrandbits(32) * random.choice([-1,1]))

count = countZeroTriples(vals)
print(f"Prob: { count/(n**3):.4f}")  # approx