
# pepys.py
# Intro to Programming in Python", Sedgewick & Wayne
# Q.1.3.40, p.98
# inputs:  6 2  or 12 2 or 18 3

'''
Pepys wrote to Newton to ask which of 3 events is more likely: that a person 
(a) gets at least 1 six when 6 dice are rolled,
(b) at least 2 sixes when 12 dice are rolled, or 
(c) at least 3 sixes when 18 dice are rolled? What is the answer?

With 6 dice 0.6649 prob of a six being rolled at least 1 time.
With 12 dice 0.6185 prob of a six being rolled at least 2 times.
With 18 dice 0.5975 prob of a six being rolled at least 3 times.
'''

import random

NUM_TRIALS = 100000

numDice, threshold = map(int, input("numDice threshold=? ").split())

thresholdMet = 0
for _ in range(NUM_TRIALS):
  numSixes = 0
  for _ in range(numDice):
    if random.randint(1, 6) == 6:
      numSixes += 1

  if numSixes >= threshold:
    thresholdMet += 1


print(f"Prob: {thresholdMet/NUM_TRIALS:.4f}")



