
# exprEval.py

import math
import matplotlib.pyplot as plt

def poor_eval(x):
    return 1/(math.sqrt(x**2 + 1) - x)

def good_eval(x):
    return (math.sqrt(x**2 + 1) + x)


for v in [1000, 10000, 1000000, 10000000]:
  print(f"{v:8d} poor: {poor_eval(v):.8f}; good: {good_eval(v):.8f}")

'''
xs = list(range(0,200))
ys = [abs(poor_eval(x)-good_eval(x)) for x in xs] 

# plt.yscale("log")
plt.loglog(xs, ys)
plt.title("Abs Diffs in Evaluations")
plt.show()
'''
