
# reader.py

def readVals(fnm):
  with open(fnm) as file:
    for line in file:
       for value in line.split():
          yield value


def readFloat1D(rdr):
  count = int(next(rdr))
  vals = []
  for i in range(count):
    vals.append( float(next(rdr)))
  return vals


def readFloat2D(rdr):
  numRows = int(next(rdr))
  numCols = int(next(rdr))
  # vals[x][y]
  vals = [[0.0 for y in range(numCols)] for x in range(numRows)]
  for r in range(numRows):
    for c in range(numCols):
      vals[r][c] = float(next(rdr))
  return vals
