
# pell.py
# inputs: 61  or  109  or  181  or 277
'''

To solve equations of the form:

x^2 - Dy^2 = 1

for D a non-square positive integer, N an integer 
and both x and y integer. This is known as a quadratic diophantine 
equation but is also known as Pell’s equation when N = 1.

Output:
x^2 -  61*y^2 = 1  
  x = 1766319049
  y = 226153980

x^2 - 109*y^2 = 1
  x = 158070671986249
  y = 15140424455100

x^2 - 181*y^2 = 1
  x = 2469645423824185801
  y = 183567298683461940

x^2 - 277*y^2 = 1
  x = 159150073798980475849
  y = 9562401173878027020
'''

import math
import decimal
from decimal import Decimal as D
from cfLib import *


d = int(input("d? "))

decimal.getcontext().prec = 100
cfList = cfDecList(D(d).sqrt(), 200)
# print(cfList)
cs = convergentsAll(cfList)
# print(cs)

nSolns = 0
for i in range(len(cs)):
  p, q = cs[i]
  res = p*p - d*q*q
  if res == 1:
    print("Success:", i, cs[i], p*p - d*q*q)
    nSolns += 1
  elif res == -1:
    print("Success:", i, cs[i], p*p - d*q*q)
    nSolns += 1
  if nSolns == 2:
    break

