
# fTile.py
# Andrew Davison, ad@coe.psu.ac.th, April 2025
'''
  Basic manipulations of an "F" shape.
  Uncomment the code that corresponds to the "F" example at
    "Programming with Escher"
    Massimo Santini
    https://mapio.github.io/programming-with-escher/
'''

from matplotlib import pyplot as plt
from Tile import *


if __name__ == "__main__":
  fig, ax=plt.subplots(figsize=(6, 6))
  ax.set_aspect('equal')
  ax.set_xlim(-2, 2)
  ax.set_ylim(-2, 2)
  ax.axis('off')
  
  blank = Tile()  # an 'empty' tile
  f = Tile.read('f')  # the "F" tile
  
  # f.show(ax)
  # rot(f).show(ax)
  # flip(rot(f)).show(ax)

  # rot(flip(f)).show(ax)
  # rot(rot(rot(f))).show(ax)
  # beside(f, rot(f)).show(ax)
  # above(flip(f), f).show(ax)
  # over(f, flip(f)).show(ax)
  
  q = quartet(flip(rot(rot(rot(f)))), 
              rot(rot(rot(f))), rot(f), flip(rot(f)))
  # q.show(ax)
  
  grid = nonet( f, f,     f, 
                f, blank, f, 
                f, f,     f )
  grid.show(ax)

  plt.show()