
# ShowPath.py
# Andrew Davison, ad@coe.psu.ac.th, April 2025
'''
Load a file containing SVG commands that define
a single path, and display in matplotlib as a PathPatch.
'''

import math

from matplotlib import pyplot as plt
from matplotlib.path import Path
from matplotlib.patches import PathPatch
from matplotlib.transforms import Affine2D

from svgpath2mpl import parse_path
   # https://pypi.org/project/svgpath2mpl/
   # pip install svgpath2mpl

  
fnm = input("Path filename (no extension): ")
pathStr = open(fnm+'.path', 'r', encoding='utf-8').read()

path = parse_path(pathStr)
path = path.transformed(  # flip and move to first quadrant
       Affine2D().scale(1,-1).translate(0,1))

_, ax=plt.subplots(figsize=(6, 6))
ax.set_aspect('equal')
ax.set_xlim(-1, 1.5)
ax.set_ylim(-1, 1.5)
# ax.axis('off')

ax.add_patch(PathPatch(path, fill=False))

plt.title(f"Plot of {fnm}.path")
plt.show()