
# interps.py
# Andrew Davison, ad@coe.psu.ac.th, August 2025

'''
The angles are measured between the reference 
direction and the rotated direction.

LERP is less smooth and non-uniform in angle space.

SLERP gives constant angular velocity (ideal for 
smooth animation or rotation blending).
'''

import math
import matplotlib.pyplot as plt
from Quat import Quat
from Vec import Vec

# Create two quaternions: 0° and 180° rotation about Y-axis
q1 = Quat.fromAxisAngle(Vec(0, 1, 0), 0)
q2 = Quat.fromAxisAngle(Vec(0, 1, 0), math.pi)
vRef = Vec(1, 0, 0)  # Reference direction

tValues = []
angleLerp = [] ; angleSlerp = []
for i in range(101):
  t = i / 100
  qLerp = Quat.lerp(q1, q2, t)
  qSlerp = Quat.slerp(q1, q2, t)

  vL = qLerp.rotateVec(vRef)
  vS = qSlerp.rotateVec(vRef)

  tValues.append(t)
  angleLerp.append( vRef.angleToDeg(vL))
  angleSlerp.append( vRef.angleToDeg(vS))

# Plot both curves on one graph
plt.figure(figsize=(8, 5))
plt.plot(tValues, angleLerp, label="LERP", color="red", ls='--')
plt.plot(tValues, angleSlerp, label="SLERP", color="blue")
plt.xlabel("t")
plt.ylabel("Rotation Angle (degrees)")
plt.title("Quaternion Interpolation: Angle vs t")
plt.legend()
plt.grid(True)
plt.tight_layout()
plt.show()
