
# TourSquad.py
# Andrew Davison, ad@coe.psu.ac.th, August 2025
'''
  Draw a squad curve between cities in the tour list
  on an Orthographic map.
  See TourSlerps.py for a curve made from Great Circles.
'''
import math

import cartopy.crs as ccrs
import cartopy.feature as cf
import matplotlib.pyplot as plt

import nav
from Quat import Quat, quatCurve



def plotCity(ax, city, lat, lon):
  # Add marker
  ax.plot(lon, lat, 'o', color='green', 
         transform=ccrs.PlateCarree())
  # label city
  ax.text(lon, lat, " "+city, color='green', 
         transform=ccrs.PlateCarree())



tour = [ 'London', 'Paris', 'Madrid', 'Rome', 
         'Bern', 'Warsaw', 'Amsterdam', 'London']

cities = nav.loadCityData()
cityCoords = [ (nav.readCoord(cities, city)) for city in tour]

quats = [ Quat.fromLatLon(*coord) for coord in cityCoords]
iQuats = quatCurve(quats, 10)
iCoords = [ q.toLatLon() for q in iQuats]


plt.figure()
ax = plt.axes(projection=ccrs.Orthographic())

lineSep = 5
ax.gridlines(draw_labels=True, ls='--',
             xlocs=range(-180, 181, lineSep),
             ylocs=range(-90, 91, lineSep))
ax.coastlines()
ax.add_feature(cf.BORDERS, ls=':')


lats, lons = zip(*iCoords)
plt.plot(lons, lats, color='blue', linestyle='--',
         transform=ccrs.PlateCarree())
                # straight lines link the coords

for i, city in enumerate(tour):
  plotCity(ax, city, *cityCoords[i])

plt.title(f"Squad Cities Tour\n")
plt.show()
