
# parabola.py
# Andrew Davison, Sept. 2025, ad@coe.psu.ac.th

import matplotlib.pyplot as plt
import bezUtils


# parabola coefficients: y = ax^2 + bx + c
a, b, c = 2, -1, 1 

def parabola(x):
  return a*x**2 + b*x + c


# Control points for exact parabola on [0,1]
ctrlPts = [(0, c), (0.5, c/2), (1, a+b+c)]

# Reference parabola
nSamps = 100
xs = [i/nSamps for i in range(nSamps+1)]
ys = [parabola(x) for x in xs]

curveX, curveY = bezUtils.bezierCurve(ctrlPts, nSamps)


plt.figure(figsize=(6, 4))

plt.plot(curveX, curveY, 
        label=f"Bézier Curve (deg {len(ctrlPts)-1})")
bezUtils.drawControlPts(plt, ctrlPts)

plt.plot(xs, ys, label="Parabola",  
               color="orange", lw=5, alpha=0.5)

plt.title("Quadratic Bézier curve for a parabola")
plt.grid(True)
plt.legend()
plt.show()

