
# bez3D.py
# Andrew Davison, Sept. 2025, ad@coe.psu.ac.th

# Plots a 3D cubic Bézier curve using Bernstein polynomials


import matplotlib.pyplot as plt
import bezUtils

ctrlPts = [ [0,0,0], [1,5,2],
            [5,1,8], [6,6,0] ]
curveX, curveY, curveZ = bezUtils.bezier3D(ctrlPts)

fig = plt.figure(figsize=(8, 6))
ax = fig.add_subplot(111, projection='3d')

plt.plot(curveX, curveY, curveZ,
        label=f"Bézier Curve (deg {len(ctrlPts)-1})")

xs, ys, zs = zip(*ctrlPts)
plt.plot(xs, ys, zs, 'ro--', markersize=5, lw=1,
                     label="Control polygon")

ax.set_xlabel('X')
ax.set_ylabel('Y')
ax.set_zlabel('Z')
ax.set_title('3D Cubic Bézier Curve')
ax.grid(True)
ax.legend()
plt.show()
