
# absorbReds.py
# Andrew Davison, June 2025, ad@coe.psu.ac.th
'''
# reds.txt
# exercise 9

labels: 0 1  2 3

  1    0    0   0
0.25 0.75   0   0
  0   0.4  0.6  0
  0    0   0.5 0.5
'''

from Mat import *
from MarkovLib import *

pLabels, P = readMarkov("reds")
print("P:")
matLabels(P, pLabels)
graph("reds", pLabels, P)

# split matrix assuming absorbing state is in first row
last = P.nRows
qIndices = list(range(1, last))
Q = P.submatrix(qIndices, qIndices)
         # transient -> transient
qLabels = pLabels[1:last]

R = P.submatrix(qIndices, [0])
         # transient -> absorbing
rLabels = [pLabels[0]]

print("Q:")
matLabels(Q, qLabels)
print("R:")
matLabels(R, qLabels, rLabels)


N, B, t = absorb(Q, R)
print("Fundamental Matrix N:")
matLabels(N, qLabels)

print("Expected Times to Absorption t:")
matLabels(t, qLabels, [""])

print("Absorption Probs Matrix B:")
matLabels(B, qLabels, rLabels)

