# logSDIC.py: 

'''
Illustrate sensitive dependence on initial
conditions in the logistic map.
Based on LogisticMap.py, we look at the time series
of two close initial conditions.
'''

import matplotlib.pyplot as plt


# The number of iterations to generate
N_ITERS  = 50

def logistic(r, x):
	return r * x * (1 - x)

r  = 3.7

# Initial conditions
xs1 = [0.1]
xs2 = [xs1[0] + 1e-5]


for n in range(N_ITERS):
  xs1.append( logistic(r,xs1[n]) )
  xs2.append( logistic(r,xs2[n]) )

plt.xlabel('Time step n') 
plt.ylabel('x(n)') 
plt.title('Logistic maps at r='+str(r))
plt.plot(xs1, 'b', alpha=0.5, label="x0="+str(xs1[0]))
plt.plot(xs2, 'g', alpha=0.5, label="x0="+str(xs2[0]))
plt.legend()
plt.show()
