
# vGrid.py
# Andrew Davison, ad@coe.psu.ac.th, April 2025
'''
 Tile the 2D plane with a 'V' shape repeated
 around a hexagon by using rotation.

 The tiling is implemented as two rows of hexagons with 'V's,
 which repeat. The two rows are offset from each other
 so that their 'V's fit together.
'''

import math
import matplotlib.pyplot as plt
from matplotlib.patches import Polygon
from HC2Mat import *

AXIS_SIZE = 40

Y_SCALE = math.sqrt(3)/2  # scaling for y-axis coords

# Hexagon (x,y) and v rotation at that point
HEX_CORNERS = [(1,-2,0), (2,0,60), (1,2,120),
               (-1,2, 180), (-2,0,240), (-1,-2,300) ]

STEP = (6,12)  # step for moving hexagon

V_COORDS = [ (0,0), (1,0), (1.5,1*Y_SCALE), 
             (2,0), (3,0), (1.5,3*Y_SCALE)]


def drawVs(ax, cx, cy):
  # rotate and translate the "V" around a hexagon 
  # centered at (cx, cy)
  for hexCorner in HEX_CORNERS:
    x = cx + hexCorner[0]
    y = (cy + hexCorner[1])* Y_SCALE
    angle = hexCorner[2]
    m = multMatsList([ transMat(x, y),
                       rotMat(angle) ])
    coords = [applyMat(m, v) for v in V_COORDS]
    drawPoly(ax, coords)


def drawPoly(ax, coords):
  poly = Polygon(coords, closed=True,
             edgecolor='black', facecolor='none', lw=1)
             # draw the "V" in outline
  ax.add_patch(poly)


# --------------------------------------

fig, ax = plt.subplots(figsize=(7, 7))
ax.set_aspect('equal')
ax.set_xlim(-10, AXIS_SIZE)
ax.set_ylim(-10, AXIS_SIZE)
ax.axis('off')

# draw each hex row 'max' times;
# each row will contain 'max'*2 hexagons
max = 3
for hex in [(0,-4), (3, 2)]:    # use two hex starts
  for i in range(max*2):  # length of row
    for j in range(max):  # no. of rows for this hexagon
      cx = hex[0] + i*STEP[0]
      cy = hex[1] + j*STEP[1]
      drawVs(ax, cx, cy)
    
plt.show()
