
# transformPoly.py
# Andrew Davison, ad@coe.psu.ac.th, April 2025
'''
  The shape and example operations come from:
    "Elementary Linear Algebra"
    Stephen Andrilli and David Hecker
    Academic Press, 6th ed., 2023
    Section 8.8, 'Computer Graphics'

  Uncomment the example you want to run.

  Similar to affinePoly.py but using my own
  matrix transformations from HC2Mat.py

  Differences:
     * operations are applied right-to-left
     * the resulting transform matrix is printed
       and the final coordinates of the shape

'''

import matplotlib.pyplot as plt
from HC2Mat import *

_, ax = plt.subplots()
axSize = 25    # 15 or 25
ax.set_xlim(0, axSize)
ax.set_ylim(0, axSize)
ax.set_aspect('equal')
ax.grid(True)

# a "knee" shape
coords = [(8,6),(8,8),(6,10),(8,12),(10,10),(10,6)]

'''
# example 1
title = "Original shape"
m = identMat()   # dummy value for m
'''

'''
# example 2
title = "rotate 90 degs around (12,6)"
m = multMatsList([ transMat(12,6), 
                rotMat(90), transMat(-12,-6) ])
'''

'''
# example 3
title = "reflect around y = -3x+30"
m = multMatsList([ transMat(0,30), 
        reflectMat(-3), transMat(0,-30) ])
'''

'''
# example 4 
title = "scale by (0.5,4) around (6,10)"
m = multMatsList([ transMat(6,10), 
      scaleMat(0.5, 4), transMat(-6,-10) ])
'''


# example 5
title = "rotate 300 degs around (8,10), then\n" + \
        "reflect around y = -0.5x + 20"
m = multMatsList( [
      transMat(0,20), reflectMat(-0.5), transMat(0,-20),
      transMat(8,10), rotMat(300), transMat(-8,-10) ])


printMat(m)  # the transform matrix
nCoords = [applyMat(m, c) for c in coords]
for x, y in nCoords:
  print(f"({x:.2f}, {y:.2f})", end =' ')
print()

plotPoly(ax, nCoords, 'skyblue')
plt.title(title)
plt.show()
