
# sierCarpet.py

import turtle
from TurtleUtils import *

START_SIZE = 400

def carpet(t, size, level):
  if level == 0: 
    drawSquare(t, size, "black")
  else: 
    # draw 8 smaller rectangles around center;
    # create two rectangles on each side 
    sz = size/3
    for _ in range(4):
      carpet(t, sz, level-1)  # first rectangle
      t.forward(sz)
      carpet(t, sz, level-1)  # second rectangle
      t.forward(sz)
      # go to next corner
      t.forward(sz)
      t.right(90)
    scr.update()



t = turtle.Turtle()
scr = t.screen
scr.title('Sierpinski Carpet')
t.hideturtle()
t.speed(0)
scr.tracer(0)  
# stop updating screen (to make it faster)

gotoUp(t, -START_SIZE/2, START_SIZE/2)
carpet(t, START_SIZE, 4)

print("Finished")
scr.exitonclick()
