
# hilbert.py
# input: 4 or 5

import turtle, math

SIZE = 400


def upperU(t, level):
  if level > 0:
    leftU(t, level-1)
    t.setheading(270)
    t.fd(step)
    upperU(t, level-1)
    t.setheading(0)
    t.fd(step)
    upperU(t, level-1)
    t.setheading(90)
    t.fd(step)
    rightU(t, level-1)

def leftU(t, level):
  if level > 0:
    upperU(t, level-1);
    t.setheading(0)
    t.fd(step)
    leftU(t, level-1);
    t.setheading(270)
    t.fd(step)
    leftU(t, level-1)
    t.setheading(180)
    t.fd(step)
    downU(t, level-1)

def rightU(t, level):
  if level > 0:
    downU(t, level-1)
    t.setheading(180)
    t.fd(step)
    rightU(t, level-1);
    t.setheading(90)
    t.fd(step)
    rightU(t, level-1);
    t.setheading(0)
    t.fd(step)
    upperU(t, level-1);

def downU(t, level):
  if level > 0:
    rightU(t, level-1);
    t.setheading(90)
    t.fd(step)
    downU(t, level-1);
    t.setheading(180)
    t.fd(step)
    downU(t, level-1);
    t.setheading(270)
    t.fd(step)
    leftU(t, level-1);


# ---- main ----
level = int(input("level? "))


step = 400
for i in range(level):
  step = step/2 
  
# Get the start point
x = -SIZE/2 + step/2
y = SIZE/2-step/2

t = turtle.Turtle()
scr = t.screen
scr.title('Hilbert')
t.hideturtle()
t.speed(0)

t.up()
t.goto(x, y)
t.down()
upperU(t, level)

scr.exitonclick()
