
# lifts.py
# solution of execise #5 in "Digital Dice" by Paul Nahin
# https://people.math.sc.edu/Burkardt/m_src/digital_dice/digital_dice.html
# https://en.wikipedia.org/wiki/Elevator_paradox

'''
  A building has 7 floors, and there are numLifts lifts, each of which
  is at a randomly chosen floor.
  A person on floor 2 requests an lifts, wishing to go up.
  What is the probability that the first lifts to arrive is going down?
  
  23 January 2018
  
  Paul Nahin,
  Digital Dice: Computational Solutions to Practical Probability Problems,
  Princeton, 2008,

  The heart of gs.m is the n-by—4 array called lifts, in which the jth
  row describes the state of the jth elevator.

  Specifically,
   * lifts[j]["initDir"] = direction (up or down) the jth elevator is moving
     when Gamow requests service;
  
   * lifts[j]["floor"] = floor of the jth elevator when Gamow requests
     service;
  
   * lifts[j]["dist"]= distance the jth elevator has to travel to reach
     Gamow’s stop
  
   * lifts[j]["finalDir"] = direction (up or down) the jth elevator is moving
     when that lifts reaches Gamow’s stop.


Knuth, The Gamow-Stern Elevator Problem
Journal of Recreational Mathematics 2 (1969), 131—137.
  1+(1-2*p)**n)/2


'''

import random

NUM_ITERS = 100000
USER_FLOOR = 1/6

numLifts = int(input("num lifts=? "))


downTotal = 0
lifts = []
for i in range(numLifts):
  lifts.append( {"initDir":"", "floor":0.0, "dist":0.0, "finalDir":""})


for i in range(NUM_ITERS):
  for j in range(numLifts):
    lifts[j]["initDir"] = "down" if (random.random() < 0.5) else "up"  
    lifts[j]["floor"] = random.uniform(0,1)  

    if lifts[j]["floor"] < USER_FLOOR:   # below us
      if lifts[j]["initDir"] == "down":
        lifts[j]["dist"] = USER_FLOOR + lifts[j]["floor"]  # go down then come up
      else:
        lifts[j]["dist"] = USER_FLOOR - lifts[j]["floor"]  # coming up
      lifts[j]["finalDir"] = "up" 
    else:   # above us or here
      if lifts[j]["initDir"] == "down":
        lifts[j]["dist"] = lifts[j]["floor"] - USER_FLOOR  # coming down
      else:
        lifts[j]["dist"] = (11/6) - lifts[j]["floor"]  # go up then come down
      lifts[j]["finalDir"] = "down"

  # count the direction of the nearest lift
  min = lifts[0]["dist"] 
  index = 0
  for j in range(1, numLifts):
    if lifts[j]["dist"] < min:
      min = lifts[j]["dist"]
      index = j
  if lifts[index]["finalDir"] == "down":
    downTotal += 1


print(f"Estimated prob of down lifts: {(downTotal/ NUM_ITERS):.6f}")
print(f"Theoretical prob is: {(0.5 + 0.5*((1-2*USER_FLOOR))**numLifts):.6f}")
   # 5/6 for 1 lift; 13/18 for 2 lifts; 35/54 for 3 lifts

