
# isPoly-q15
# Add. Exs fir Sections 1-65, Q.15
# info:https://www.geeksforgeeks.org/check-if-it-is-possible-to-create-a-polygon-with-given-n-sides/

'''
n lengths form a (convex) polygon if and only if no one length is greater than or equal to the sum of the other lengths.

In that case, we can find the largest side, then, check whether it is smaller than the sum of the other sides
'''

import random

ITERS = 10000

def isPossible(sides):
    totSides = sum(sides)
    largestSide = max(sides)
    # Is the length of the largest side
    # less than the total of the remaining sides
    return ((totSides - largestSide) > largestSide)

n = int(input("n=? "))
numPolys = 0
for _ in range(ITERS):
  sides = []
  for i in range(n):
    sides.append( random.uniform(0,1))
  if isPossible(sides):
    numPolys += 1
print(f"{numPolys/ITERS:.4f}")
