
# schoolNu.py
# Like school.py, but includes loss of immunity.

import matplotlib.pyplot as plt
from frange import *

# Time unit: 1 h
beta = (10/4)/(40*8*24)  # Reduce beta by factor of 4
gamma = 3/(15*24)
nu = 1./(24*90)      # Average loss of immunity: 50 days

dt = 0.1             # 6 min
D = 300              # Simulate for D days
N_t = int(D*24/dt)   # Corresponding no of hours


ts = linspace(0, N_t*dt, N_t+1)
S = [0]*(N_t+1)
I = [0]*(N_t+1)
R = [0]*(N_t+1)

# Initial conditions
S[0] = 50
I[0] = 1
R[0] = 0

# Step equations forward in time
for n in range(N_t):
    S[n+1] = S[n] - dt*beta*S[n]*I[n] + dt*nu*R[n]
    I[n+1] = I[n] + dt*beta*S[n]*I[n] - dt*gamma*I[n]
    R[n+1] = R[n] + dt*gamma*I[n] - dt*nu*R[n]

plt.plot(ts, S, label="S")
plt.plot(ts, I, label="I")
plt.plot(ts, R, label="R")
plt.legend()
plt.xlabel('hours')
plt.ylabel('people')
plt.title("Flu over " + str(D) + " days, with relapses")
plt.show()
