
# tractrix.py
# input: 2  or  2.5
# https://en.wikipedia.org/wiki/Tractrix
# https://encyclopediaofmath.org/wiki/Tractrix
# https://mathworld.wolfram.com/Tractrix.html

import math
from turtle import Turtle
from TurtleUtils import *

DIST = 150  # length of chain
STEP = 2
MAX_STEP = 250

def move(t, pos, step):
  angle = t.towards(pos)
  t.setheading(angle)   # Set the direction with this angle
  t.fd(step)


def drawLineTo(t, p):
  # draw a line to p then return to original pos
  pos = t.position()
  t.hideturtle()
  t.goto(p)  
  t.goto(pos)
  t.showturtle()



man = Turtle()
man.speed(0)
scr = man.getscreen()
scr.title('Tractrix')
scr.setworldcoordinates(-30, -30, 600, 200)

man.hideturtle()
man.pencolor("blue")  # draw axes
drawLine(man, -10, 0, 580, 0)
drawLine(man, 0, -10, 0, 170)
man.pencolor("black")

gotoUp(man, 0,0)  # position man
man.setheading(0)
man.showturtle()

watch = Turtle()  # position watch
watch.speed(0)
watch.pencolor("red")
gotoUp(watch, 0, DIST)
watch.setheading(-90)

numSteps = 0
while numSteps < MAX_STEP:
  man.forward(STEP)

  manPos = man.pos()
  watchPos = watch.pos()
  watchStep = math.dist(manPos, watchPos) - DIST
         # stay at DIST distance from man
  move(watch, manPos, watchStep)

  if numSteps%10 == 0: # label the 10th steps
    drawLineTo(watch, manPos) 
  numSteps += 1

print(f"Dist apart: {math.dist(watch.pos(), man.pos()):.2f}")
                           # will = DIST
scr.exitonclick()
