
# pirates.py
# input: 2  or  2.5


import math
from turtle import Turtle
from TurtleUtils import *

EPS = 1
DIST = 100
VES_STEP = 2
MAX_STEPS = 250

def isClose(p1, p2):
  return abs( math.dist(p1,p2)) < EPS


def move(t, pos, step):
  angle = t.towards(pos)
  t.setheading(angle)   # Set the direction with this angle
  t.fd(step)


print("Merchant step:", VES_STEP)
pirateStep = float(input("Pirate step? "))

vessel = Turtle()
vessel.speed(0)
scr = vessel.getscreen()
scr.title('Pirate Pursuit')
scr.setworldcoordinates(-50, -50, 220, 500)

vessel.hideturtle()
vessel.pencolor("blue")   # draw axes
drawLine(vessel, -20, 0, 200, 0)
drawLine(vessel, 0, -20, 0, 480)
vessel.pencolor("black")

pirate = Turtle()   # position pirates
pirate.speed(0)
pirate.pencolor("red")

gotoUp(vessel, DIST, 0)  # position vessel
vessel.left(90)
vessel.showturtle()

numSteps = 0
while numSteps < MAX_STEPS:
  vessel.forward(VES_STEP)

  vesPos = vessel.pos()
  move(pirate, vesPos, pirateStep) # towards vessel

  numSteps += 1
  pirPos = pirate.pos()
  if numSteps%20 == 0:  # label the 20th steps
    write(vessel, str(numSteps), vesPos[0], vesPos[1])
    write(pirate, str(numSteps), pirPos[0], pirPos[1])
  if isClose(vesPos, pirPos):
    break

if numSteps == MAX_STEPS:
  print("stopped after max steps:", numSteps)
else:
  print("No. steps:", numSteps)
vesPos = vessel.pos()
pirPos = pirate.pos()
print("Vessel pos:", vesPos)
print("Pirate pos:", pirPos)
print(f"Dist apart: {math.dist(vesPos, pirPos):.2f}")

scr.exitonclick()
