
# orthoPirates.py
# input: 1.3  or  2  or  2.5


import math
from turtle import Turtle
from TurtleUtils import *

EPS = 2
DIST = 200
VES_STEP = 2
MAX_STEP = 200

def isClose(p1, p2):
  return abs( math.dist(p1,p2)) < EPS


def move(t, pos, step):
  angle = t.towards(pos)
  t.setheading(angle)   # Set the direction with this angle
  t.fd(step)


pirateStep = float(input("Pirate step? "))

vessel = Turtle()
vessel.hideturtle()
vessel.speed(0)
scr = vessel.getscreen()
scr.title('Pirate Pursuit')

vessel.pencolor("blue")   # draw axes
drawLine(vessel, -250, 0, 250, 0)
drawLine(vessel, 0, -250, 0, 250)
vessel.pencolor("black")

pirate = Turtle()  # position pirate
pirate.speed(0)
pirate.pencolor("red")

gotoUp(vessel, DIST, 0)  # position vessel
vessel.left(90)
vessel.showturtle()

numSteps = 0
while numSteps < MAX_STEP:
  vessel.setheading(pirate.heading()+90) # set othogonal
  vessel.forward(VES_STEP)

  vesPos = vessel.pos()
  move(pirate, vesPos, pirateStep)

  numSteps += 1
  pirPos = pirate.pos()
  if numSteps%20 == 0: # label the 20th steps
    write(vessel, str(numSteps), vesPos[0], vesPos[1])
    write(pirate, str(numSteps), pirPos[0], pirPos[1])
  if isClose(vesPos, pirPos):
    break

print("No. steps:", numSteps)

scr.exitonclick()
