import turtle


# goto a position with the pen up, then pen down at end
def gotoUp(t, x, y):
  t.up()
  t.goto(x, y)
  t.down()
  

# Draw a line from (x1, y1) to (x2, y2)
def drawLine(t, x1, y1, x2, y2):
  gotoUp(t, x1, y1)
  t.goto(x2, y2)

def drawPos(t, pos1, pos2):
  drawLine(t, pos1[0], pos1[1], pos2[0], pos2[1])


# Write a text at (x, y)
def write(t, msg, x, y): 
  pos = t.pos()
  t.setpos(x, y)
  t.write(msg)
  t.setpos(pos)


# Draw a point at (x, y)
def drawPoint(t, x, y): 
  gotoUp(t, x, y)
  t.begin_fill()
  t.circle(3) 
  t.end_fill()


# Draw a circle at centered at (x, y) with the specified radius
def drawCircle(t, x, y, radius): 
  gotoUp(t, x, y - radius)
  t.circle(radius) 
  

# Draw a rectangle at (x, y) with the specified width and height
def drawRectangle(t, x, y, width, height): 
  gotoUp(t, x + width / 2, y + height / 2)
  t.right(90)
  t.fd(height)
  t.right(90)
  t.fd(width)
  t.right(90)
  t.fd(height)
  t.right(90)
  t.fd(width)


def drawSquare(t, size):
  for i in range(4):
    t.fd(size)
    t.right(90)

def drawTriangle(t, size):
  for i in range(3):
    t.fd(size)
    t.right(120)

def drawPolygon(t, size, n):
  for i in range(n):
    t.fd(size)
    t.right(360.0 / n)
