
# drawPolys.py
import math
from turtle import Turtle

NUM_POLYS = 15
SCALE = 50

def drawPolygon(t, r, n):
  t.pencolor("red")
  t.pendown()
  lineLen = SCALE*r*(2*math.sin(math.pi/n))
  if (n > 2) and (lineLen > 0):
    angle = 360 / n
    for i in range(n):
      t.forward(lineLen)
      t.left(angle)
  t.penup()


def drawCircle(t, r):
  t.pencolor("blue")
  t.pendown()
  t.circle(SCALE*r)
  t.penup()


# -----------------------------

t = Turtle()
t.hideturtle()
t.speed(0)
scr = t.getscreen()
scr.title('Polygon Circumscribing')
t.pensize(2)
t.penup()

r = 1
print("sides  radius")
for n in range(3, NUM_POLYS):
  t.home()
  t.forward(SCALE*r)
  t.left(90)  
  drawCircle(t, r)

  # n-gon around the circle
  r = r/math.cos(math.pi/n)
  print(f"{n:4d}   {r:.4f}")
  t.home()
  t.setheading(-90 + 180/n)
  t.forward(SCALE*r)
  t.left(90+(180/n))  
  drawPolygon(t, r, n)

print("Finished")
scr.exitonclick()