
# ramaPi.py
'''
  Computes an estimate of pi.
  Algorithm due to Srinivasa Ramanujan, from 
  http://en.wikipedia.org/wiki/Pi
  https://en.wikipedia.org/wiki/Srinivasa_Ramanujan

  input:
     1000       0.060 secs; 127 steps
     10000     35.954 secs; 1254
     50000         ?? secs
'''

import math, time
import decimal
from decimal import Decimal as D, getcontext
from decTrig import *


def piRama():
  decimal.getcontext().prec += 2  
          # extra digits for intermediate steps
  total = D(0)
  factor = 2 * D(2).sqrt() / 9801
  pi = None
  k = 0
  while True:
    num = math.factorial(4*k) * (1103 + 26390*k)
    den = math.factorial(k)**4 * 396**(4*k)
    term = factor * num / den
    total += term
    k += 1
    piPrev = pi
    pi = 1/total
    # if calculated pi is not changing, break
    if pi == piPrev:
      print("No. iterations:", k)
      break
  decimal.getcontext().prec -= 2
  return +pi    # unary plus applies the new precision


d = int(input("No. dps? "))
decimal.getcontext().prec = d
startTime = time.time()
piEst = piRama()
endTime = time.time() - startTime
printGrouped(piEst)
print(f"Elapsed time: {endTime:.3f} secs")

