
# machinPi.py

'''
   Calculate pi using three different Machin-like formulae,
   and compare them with the Nut.pi 100 dp constant.

   Pi Machin formulae:
   https://en.wikipedia.org/wiki/Machin-like_formula
   https://en.wikipedia.org/wiki/Approximations_of_%CF%80#Machin-like_formula

   The Machin formulae require atan() for Decimal 
'''

import math, time
import decimal
from decimal import Decimal as D
from decTrig import *


decimal.getcontext().prec = 100

print("pi106:")    
print("    3.14159 26535 89793 23846 26433 83279 50288 41971 69399 37510 58209")
print("74944 59230 78164 06286 20899 86280 34825 34211 70679 82148")

print("\nMachin 1). pi = 4 * arctan(1)")
start = time.time()
piEst = 4*atan(D(1))
printGrouped(piEst)
print(f"Elapsed time: {(time.time() - start):.3f} secs")

frac18 = D(1)/D(18)
frac57 = D(1)/D(57)
frac239 = D(1)/D(239)

print("\nMachin 2). pi = 16*arctan(1/5) - 4*arctan(1/239)")
start = time.time()
piEst = 16*atan(D('0.2')) - 4*atan(frac239)
printGrouped(piEst)
print(f"Elapsed time: {(time.time() - start):.3f} secs")

print("\nStormer). pi = 24*arctan(1/8) + 8*arctan(1/57) + 4*arctan(1/239)")
start = time.time()
piEst = 24*atan(D('0.125')) + 8*atan(frac57) + 4*atan(frac239)
printGrouped(piEst)
print(f"Elapsed time: {(time.time() - start):.3f} secs")

print("\nGauss). pi = 48*arctan(1/18) + 32 arctan(1/57) - 20*arctan(1/239)")
start = time.time()
piEst = 48*atan(frac18) + 32*atan(frac57) - 20*atan(frac239)
printGrouped(piEst)
print(f"Elapsed time: {(time.time() - start):.3f} secs")


