
# expD.py
'''
  https://en.wikipedia.org/wiki/E_(mathematical_constant)

Evaluate expD(1) and decimal exp(1) for various precisions.
Report the time take to produce the answers, and the number
of iterations of the code for expD()

  digit
 precision              expD(1)        decimal.exp(1)
                  secs; iterations       secs
     1000        0.040; 451               0.02
    10000        4.111; 3250              4.470
   100000      242.395; 25207           274.975
   300000     1844.301; 68191          2299.737
   500000     5688.023; 108654         7579.805
      1 M    22623.750; 205023        26640.763
'''

import math, time
import decimal
from decimal import Decimal as D
from decTrig import *

def expD(x): 
  # Decimal iterative series for exp(x)
  decimal.getcontext().prec += 2
  term = D(1) 
  eVal = D(1)
  t = 1

  while True: 
    term *= x/t
    ePrev = eVal
    eVal += term 
    t += 1

    # if calculated e is not changing, break
    if eVal == ePrev:
      print("No. steps:", t-1)
      break

  decimal.getcontext().prec -= 2
  return +eVal    # unary plus applies the new precision


# ------------- main -------------

d = int(input("No. dps? "))
decimal.getcontext().prec = d

print("expD()")
startTime = time.time()
eEst = expD(D(1))
endTime = time.time() - startTime
printGrouped(eEst)
print(f"Elapsed time: {endTime:.3f} secs")

print("\nDecimal exp(1)")
startTime = time.time()
eEst = D(1).exp()
endTime = time.time() - startTime
printGrouped(eEst)
print(f"Elapsed time: {endTime:.3f} secs")
