
# exp1.py
# Fig. 59.1. Many digits of e.
'''
no. of digits;
no. of terms       1000; 451   10000; 3250    100000; 25207
running time (secs)     0.24       14.94       1232.33
'''

import time

numDigs, numTerms = map(int, input("numDigs n? ").split())  
    # number of digits,  number of terms to n-th term

start = time.time()

edigs = [0]*(numDigs+2)
edigs[0] = 1 

for n in range(numTerms, 0, -1):
  # divide edigs[] by term n
  for i in range(numDigs+1):
    q = edigs[i]//n  
    r = edigs[i]%n  # remainder
    edigs[i] = q
    edigs[i+1] += 10*r
  edigs[0] += 1

# process any carries
for i in range(numDigs, 0, -1):
  u = edigs[i]//10
  edigs[i] = edigs[i] % 10
  edigs[i-1] += u

# print the digits in groups
for i in range(numDigs+1):
  print(edigs[i], end='')
  if i % 5 == 0:
    print(" ", end ='')
  if i % 60 == 0:
    print()

print(f"\nIn {time.time()-start:.2f} secs")
