
# bppPi.py
'''
  Computes an estimate of pi.
  using Bailey-Borwein-Plouffe series (bpp)
  https://en.wikipedia.org/wiki/Bailey%E2%80%93Borwein%E2%80%93Plouffe_formula

  input:
     1000     0.100 secs; 828 steps
     10000   40.755 secs; 8300 steps
     50000   ??
'''

import math, time
import decimal
from decimal import Decimal as D, getcontext
from decTrig import *


def bppPi():
  decimal.getcontext().prec += 2  
          # extra digits for intermediate steps
  pi = D(0)
  k = 0
  while True:
    piPrev = pi
    pi += (D(1)/(16**k))*( D(4)/(8*k+1) - D(2)/(8*k+4) -
                           D(1)/(8*k+5) - D(1)/(8*k+6) )
    k += 1
    # if calculated pi is not changing, break
    if pi == piPrev:
      print("No. steps:", k)
      break
  decimal.getcontext().prec -= 2
  return +pi    # unary plus applies the new precision



d = int(input("No. dps? "))
decimal.getcontext().prec = d

startTime = time.time()
piEst = bppPi()
endTime = time.time() - startTime

printGrouped(piEst)
print(f"Elapsed time: {endTime:.3f} secs")
