
# archimedesPi.py
# compute approximation for pi
# https://www.craig-wood.com/nick/articles/pi-archimedes/
'''
  input:
     1000       0.570 secs
     5000      64.076 secs
'''

import math, time
import decimal
from decimal import Decimal as D
from decTrig import *


def archPi():
  decimal.getcontext().prec += 2  
          # extra digits for intermediate steps
  pi = D(3)
  edgeSqr = D(2)  # start with a square
  sides = 4
  while True:
    edgeDiff = 1 - edgeSqr/4 
    prevES = edgeSqr
    edgeSqr = 2 - 2*edgeDiff.sqrt()
    sides *= 2
    prevPi = pi
    pi = sides * edgeSqr.sqrt()/2

    # if calculated pi is not changing, break
    if pi == prevPi:
      break

  decimal.getcontext().prec -= 2
  return +pi    # unary plus applies the new precision



d = int(input("No. dps? "))
decimal.getcontext().prec = d

startTime = time.time()
piEst = archPi()
endTime = time.time() - startTime

printGrouped(piEst)
print(f"Elapsed time: {endTime:.3f} secs")
