
# evalSine.py
# langtangen, B.1.2, Interpolation, p. 685

# input: 1.41421356237 and 5 or 10 or 20

import math
import matplotlib.pyplot as plt
from frange import *


def S_k(k):
  return ys[k] + \
       ((ys[k+1] - ys[k])/(xs[k+1] - xs[k]))*(x - xs[k])


# --------- main -----------

x = float(input("x? "))
n = int(input("n? "))

h = math.pi/n
k = int(x/h)

xs = linspace(0, math.pi, n+1)
ys = [math.sin(x) for x in xs]

print("Approximation of sin({x}):", S_k(k))
print("Exact value of sin({x}):  ", math.sin(x))
print("Error in approximation:   ", math.sin(x) - S_k(k))
