# cos
# Fig. 55.3
# inputs: 60

import math

EPS = 1e-10

def cosApprox(x):
  e = math.sqrt(12*EPS)
  p = 0
  while abs(x) > e:
    x = x/2
    p += 1

  f = -x*x/2
  for _ in range(p):
    f = 2*f*(2+f)
  return f

x = math.radians(float(input("degrees? ")))
print(f"cos x = {1+cosApprox(x):.10f}")
