
# archimedes.py
# https://www.craig-wood.com/nick/articles/pi-archimedes/

import math

ITERS = 16

def archimedes(n):
  # calculate n iterations of Archimedes PI relation
  edgeSqr = 2.0
  numSides = 4
  for i in range(n):
    edgeSqr = 2 - 2*math.sqrt(1 - edgeSqr/4)
    numSides *= 2
  return numSides * math.sqrt(edgeSqr)/2


for i in range(ITERS):
  res = archimedes(i)
  err = res - math.pi
  print(f"{i:2} iters: {res:.10f}; error: {err:.10f}")


