# arcit
# Fig. 53.2
# inputs 0, 1e-7

import math

EPS = 1e-10

def arccosApprox(c):
  s = math.sqrt(1-c*c)
  while abs(1-c) > EPS:
    c = math.sqrt((1+c)/2)
    s = s/c
  return s

c = float(input("c? "))
s = arccosApprox(c)
print(f"arc == {s:.10f}; 2s == {2*s:.10f}")
