
# gcMap.py

from grays import *
import matplotlib.pyplot as plt

n = int(input("n? "))

gcs = [list(map(int, gc)) for gc in grayCodes(n)]
  # ['1', '0', ...] -> [1, 0, ...]
 
# display the categories as x- and y- axis labels
plt.xticks(ticks=range(n), labels=range((n-1),-1,-1))
plt.xlabel("bits")
plt.ylabel("value")

plt.imshow(gcs, cmap='Greys',
                    origin="lower",
                    interpolation="nearest")

plt.title("Gray Code Map (n="+str(n)+")")
plt.show()