# wythoff 
# Fig. 48.6 
# input: 18 or 30

import matplotlib.pyplot as plt
from matplotlib.ticker import MultipleLocator

n = int(input("n=? "))

avails = [True]*2*(n+1)
  # integers available for use in pairs
xs = [0]*(n+1)
ys = [0]*(n+1)

i = 0
for j in range(1,n+1):
  if avails[j]: 
    i += 1
    xs[i] = j    # smallest int not yet used
    ys[i] = j+i  # sum of xs[i] and i
    avails[i] = False    # i, j+1 have been used
    avails[j+i] = False

print(" n   xs  ys")
for j in range(i+1):
  print(f"{j:2d}:  {xs[j]:2d}  {ys[j]:2d}")

max = ys[i]

ax = plt.gca()

plt.scatter(xs, ys)
plt.xlim(0, max+1)
plt.ylim(0, max+1)

minorLoc = MultipleLocator(1)
minorLoc.tick_values(0, max+1)
ax.yaxis.set_minor_locator(minorLoc)
ax.xaxis.set_minor_locator(minorLoc)

majorLoc = MultipleLocator(5)
ax.yaxis.set_major_locator(majorLoc)
ax.xaxis.set_major_locator(majorLoc)
ax.grid(which = 'both')

ax.set_aspect('equal', adjustable='box')

plt.xlabel("xs")
plt.ylabel("ys")
plt.title("Wythoff's Game Losing Positions")
plt.show()