
# sendmory.py

from itertools import permutations


def solve_cryptarithmetic():
  # Define the letters and possible digits
  letters = ('S', 'E', 'N', 'D', 'M', 'O', 'R', 'Y')
  digits = list(range(10))
  
  # Generate all possible permutations of digits for the letters
  for perm in permutations(digits, len(letters)):
    sol = dict(list(zip(letters, perm)))
    
    # Check for leading zeros
    if sol['S'] == 0 or sol['M'] == 0:
      continue
    
    # Calculate the values for SEND, MORE, and MONEY
    send = 1000 * sol['S'] + 100 * sol['E'] + 10 * sol['N'] + sol['D']
    more = 1000 * sol['M'] + 100 * sol['O'] + 10 * sol['R'] + sol['E']
    money = 10000 * sol['M'] + 1000 * sol['O'] + 100 * sol['N'] + 10 * sol['E'] + sol['Y']
    
    # Check if the equation holds true
    if send + more == money:
      print(f"  SEND:  {send} +")
      print(f"  MORE:  {more}")
      print("----------------")
      print(f" MONEY: {money}")
      return sol

# ------------- main ------------------
solution = solve_cryptarithmetic()
print(solution)