
# cryptarithmetic.py

# info: https://en.wikipedia.org/wiki/Verbal_arithmetic

'''
 S E N D  +  M O R E  =  M O N E Y

 T O  +  G O  =  O U T
'''


import itertools


def checkMoney(sol):
  if (sol['s'] == 0) or (sol['m'] == 0):
    return False
  send = 1000 * sol['s'] + 100 * sol['e'] + 10 * sol['n'] + sol['d']
  more = 1000 * sol['m'] + 100 * sol['o'] + 10 * sol['r'] + sol['e']
  money = 10000 * sol['m'] + 1000 * sol['o'] + 100 * sol['n'] + 10 * sol['e'] + sol['y']
  return (send + more == money)


def checkOut(sol):
  if (sol['t'] == 0) or (sol['g'] == 0) or (sol['o'] == 0):
    return False
  to = 10 * sol['t'] + sol['o']
  go = 10 * sol['g'] + sol['o']
  out = 100 * sol['o'] + 10 * sol['u'] + sol['t']
  return (to + go == out)


def genTest(letters, fn):
  print("\nAssigning values to", letters)
  for perm in itertools.permutations(range(10), len(letters)):
    sol = dict(zip(letters, perm))
    if fn(sol):
      print("  ", sol)



genTest(['t', 'o', 'g', 'u'], checkOut)

genTest(['s', 'e', 'n', 'd', 'm', 'o', 'r', 'y'], checkMoney)