
# sortTimings.py
# Time the different sorting functions

import math
import sys, time
import matplotlib.pyplot as plt

from arrUtils import *

# from bubbleSort import *
# from heapSort import *
from insertionSort import *
from mergeSort import *
from quickSort import *
from radixSort import *
from selectionSort import *
from shellSort import *


NUM_ITERS = 5

def timer(fn, n):
  ts = [0]*NUM_ITERS
  for i in range(NUM_ITERS):
    elems = genArr(n)
    start = time.time()
    fn(elems)
    ts[i] = time.time() - start
  return sum(ts)/NUM_ITERS


def pSort(elems):
  elems.sort()



sys.setrecursionlimit(10**6)

elems = []
ns = [] 
ps = []; bs = []; ins = []; hs = []
ms = []; qs = []; rs = []
ses = []; shs = []

# for n in range(1000000, 11000001, 1000000):
for n in range(1000, 10001, 1000):
# for n in range(1000, 110001, 1000):
  ns.append(n)
  ps.append( timer(pSort, n))
  # bs.append( timer(bubbleSort, n))
  ins.append( timer(insertionSort, n))
  # hs.append( timer(heapSort, n))
  ms.append( timer(mergeSort, n))
  qs.append( timer(quickSortL, n))
  rs.append( timer(radixSort, n))
  ses.append( timer(selectionSort, n))
  shs.append( timer(shellSort, n))

plt.plot(ns, ps, label="python sort", ls='-.')
# plt.plot(ns, bs, label="bubble sort")
plt.plot(ns, ins, label="insertion sort",lw=3)
# plt.plot(ns, hs, label="heap sort")
plt.plot(ns, ms, label="mergesort", ls='--')
plt.plot(ns, qs, label="quicksort", ls='--')
plt.plot(ns, rs, label="radix sort")
plt.plot(ns, ses, label="selection sort")
plt.plot(ns, shs, label="shell sort", ls=':')

plt.legend()
plt.xlabel("List size")
plt.ylabel("Secs")
plt.title('Times for Sorting')

plt.show()





