
# selectionSort.py

import time
from arrUtils import *

def selectionSortR(elems):
  selSort(elems, 0, len(elems)-1)


def selSort(elems, low, high):
  if low < high:
    # Find index of smallest number
    minIdx = low;
    for i in range(low+1, high+1):
      if elems[i] < min:
        minIdx = i
    # swap elements
    elems[low], elems[minIdx] = elems[minIdx], elems[low]

    # Sort the remaining elems[low+1 .. high]
    selSort(elems, low+1, high)


def selectionSort(elems):
  n = len(elems)
  for idx in range(n):
    minIdx = idx
    for j in range(idx+1, n):
      # Find index of smallest number
      if elems[j] < elems[minIdx]:
        minIdx = j
    # swap elements
    elems[idx], elems[minIdx] = elems[minIdx], elems[idx]



if __name__ == "__main__":
  n = int(input("n? "))
  elems = genArr(n)
  start = time.time()
  selectionSort(elems)
  printPartArr(elems)
  print(f"Time: {(time.time()-start):.4f} secs")
