
# priSort.py

'''
  Challenging Programming in Python
  Habib Izadkhah, Rashid Behzadidoost
  Springer, 2024
  Code 4.16

  List, set 						Expected output
  [5,2,7,3,2,1,29], {2,7} 			[2,2,7,1,3,5,29]
  [1,4,8,9,13,11,17], {11,12} 		[11,1,4,8,9,13,17]
  [4,5,7,13,290], {3,4,1,8} 		[4,5,7,13,290]
  [4,-2,5,7,13,-8,9,8], {2,4,1,8}	[-8,4,-2,5,7,8,9,13]

'''

def priSort(elems, elSet):
  # Sort the elems based on the elements in the set
  if not elems:
    return elems

  sortedElems = []
  setSize = len(elSet)
  for _ in range(setSize):
    if min(elSet) in elems:
      val = min(elSet)
      numTimes = elems.count(val)
      for _ in range(numTimes):
        # append as many times as it appears in the elems
        sortedElems.append(val)
        elems.remove(val)
    elSet.remove(min(elSet))

  n = len(elems)
  for _ in range(n):
    minElem = min(elems)
    sortedElems.append(minElem)
    elems.remove(minElem)

  return sortedElems


# ------ main ----------
elems = [5,2,7,3,2,1,29]
elSet = {2,7}
print(elems, elSet)
print(priSort(elems, elSet))

elems = [1,4,8,9,13,11,17]
elSet = {11,12}
print(elems, elSet)
print(priSort(elems, elSet))
