
# bucketsort2.py

from insertionSort import *

def bucketSort(elems):
  n = len(elems)
  buckets = [[] for _ in range(n)]

  # Put elements in different buckets
  for num in elems:
    bi = int(n * num)
    buckets[bi].append(num)

  # Sort individual buckets using insertion sort
  for bucket in buckets:
    insertionSort(bucket)

  # Concatenate all buckets into elems[]
  index = 0
  for bucket in buckets:
    for num in bucket:
      elems[index] = num
      index += 1

if __name__ == "__main__":
  elems = [0.897, 0.565, 0.656, 0.1234, 0.665, 0.3434]
  bucketSort(elems)
  print(elems)

