
# arrUtils.py

import math, random, time

MAX_WIDTH = 9

def genArr(n):
  elems = [0]*n
  for i in range(n):
    elems[i] = random.randrange(1, 10*n)
  return elems


def printArr(elems):
  n = len(elems)
  print("----")
  for i in range(n):
    print(f"{elems[i]:7d}", end=' ')
    if (i+1) % MAX_WIDTH == 0:
      print()
  print()
  print("----")


def printPartArr(elems):
  n = len(elems)
  if MAX_WIDTH*4 > n:
    printArr(elems)
  else:
    print("----")
    for i in range(MAX_WIDTH*2):
      print(f"{elems[i]:7d}", end=' ')
      if (i+1) % MAX_WIDTH == 0:
        print()
    print("...")
    end = n - (MAX_WIDTH*2)
    for i in range(end, n):
      print(f"{elems[i]:7d}", end=' ')
      if (i+1) % MAX_WIDTH == 0:
        print()
    print()
    print("----")


if __name__ == "__main__":
  n = int(input("n? "))
  elems = genArr(n)
  start = time.time()
  elems.sort()
  printPartArr(elems)
  print(f"Time: {(time.time()-start):.4f} secs")
